-- ---------------------------------------------------------------
-- 	Relative Latency
-- ---------------------------------------------------------------
--	$Header
-- ---------------------------------------------------------------
--
--	Program Name	:	RelativeLatency
--	Function		:	script executed by Geneos netprobe
--					:	to compare latency between two feeds
--	Author			:	Richard Gould
--	Language		:	Lua (5.1)
--	Creation		:	01/02/2015
--	History			:
--
--	01/02/2015	0.00 -> 1.00	RG	Creation
--  25/06/2015	1.00 -> 2.00	RG	Adaption
--
-- ---------------------------------------------------------------
local Program =  "RelativeLatency"
local Version =  "2"
local Revision = "01"
-- ---------------------------------------------------------------

local sa = require "geneos.sampler"
local lt = require "geneos.latency"
local md = require "geneos.marketdata"
local he = require "geneos.helpers"

-- ---------------------------------------------------------------
-- Config file is pathed by parameter from Gateway

local ConfigDir = sa.params[ 'ConfigDir' ]

package.path = package.path .. ";" .. ConfigDir .. "?.lua"

local config = require "config"

-- ---------------------------------------------------------------
-- These are the default values

local baseFeedName = sa.params[ 'baseFeedName' ] or "bloomberg"
local altFeedName  = sa.params[ 'altFeedName'  ] or "bloomberg"

if ( baseFeedName == altFeedName ) then
	altFeedName = baseFeedName .. "A"
end

local viewName = sa.params[ 'viewName' ] or "Relative Latency"

-- Timezone offset
config.offset = config.offset or 0

-- Base
config[ baseFeedName ].instruments = config[ baseFeedName ].instruments or config.bloominstruments
config[ baseFeedName ].fields      = config[ baseFeedName ].fields      or config.bloomfields

-- Second
config[ altFeedName ].instruments = config[ altFeedName ].instruments or config.bloominstruments
config[ altFeedName ].fields      = config[ altFeedName ].fields      or config.bloomfields

-- End of Defaults

local SampleTime = he.formatTime( "%d/%m/%y %H:%M:%S", he.gettimeofday() )

local ctx = lt.newContext()					-- create the context object here
	ctx:setBase( baseFeedName, config[ baseFeedName ] )	-- Register the base feed
	ctx:addFeed( altFeedName,  config[ altFeedName  ] )	-- add an alt feed
	ctx:start()						-- start the system

-- creating view
local cols = { "feed", "status", "numTicks", "numMatches", "minLatency", "maxLatency" }
local view = sa.createView( viewName, cols )

view.headline.baseFeed = baseFeedName
view.headline.altFeed  = altFeedName
view.headline.Now      = SampleTime
view.headline.Version  = Version .. "." .. Revision
view:publish()

sa.doSample = function()

	SampleTime = he.formatTime( "%d/%m/%y %H:%M:%S", he.gettimeofday() )

	ctx:sample()						-- instruct the latency context to update its stats
	local Base_metrics = ctx:getMetrics( baseFeedName )	-- grab metrics from base feed
	local Alt_metrics  = ctx:getMetrics( altFeedName  )	-- grab metrics from alt feed

	view.row = {}
	view.row[ baseFeedName ] = {
		ctx:getFeedStatus( 0 ),
--		ctx.base.feed:getStatus(),		-- status of base feed
		Base_metrics.numTicks,			-- add remaining stats to row
		Base_metrics.matches,
		"",								-- note base feed will have no latency stats
		""
	}

	view.headline.Now = SampleTime
	view:publish()

	local min = ""
	if ( Alt_metrics.latMin ~= nil ) then
		min = string.format( "%0.0f", Alt_metrics.latMin * 1000 )	-- handle formatting in case of nil value
	end
	local max = ""
	if ( Alt_metrics.latMax ~= nil ) then
		max = string.format( "%0.0f", Alt_metrics.latMax * 1000 )
	end

	view.row[ altFeedName ] = {
		ctx:getFeedStatus( 1 ),
		Alt_metrics.numTicks,						-- add remaining stats to row
		Alt_metrics.matches,
		min,
		max
	}

	view:publish()
end
