-- ---------------------------------------------------------------
-- 	Configuration Script
-- ---------------------------------------------------------------
--	$Header
-- ---------------------------------------------------------------
--
--	Program Name	:	config
--	Function		:	script required by Geneos netprobe
--					:	to examine a Market Data Feed Sampler
--	Author			:	Richard Gould ( ITRS )
--	Language		:	Lua (5.1)
--	Creation		:	01/02/2015
--	History			:
--
--	01/02/2015	0.00 -> 1.00	RG	Creation
--	01/07/2015	1.00 -> 2.00	RG	Adaption
--
-- ---------------------------------------------------------------
local Program =  "config"
local Version =  "2"
local Revision = "01"
-- ---------------------------------------------------------------
-- Common Configuration File

-- defines default parameters

-- define connection etc parameters for individual feeds


local m = {}

-- general location of feed library files

m.libpath = "/home/geneos/packages/netprobe/active_005/flm/"

-- extension for library files, ( .so for IX, .dll for Windows )

m.libext = (package.config:sub(1,1) == "/") and ".so" or ".dll"

-- Timezone offset ( from the feed's timestamp to local timestamp )

m.offset = 0

--	Default limit display rows

m.limit = 20

-- Time between ticks seconds

m.TickInterval = 30

--	deviation from value as a %

m.Tolerance = "10"

-- Feed Configurations

-- general location of rfa config files

m.rfapath = "/home/geneos/mdm/"


--	The Standard Feed Configurations

-- Bloomberg Feed
m.bloomberg = {
	feed = {
		type = "bloomberg",
		[ "library.filename" ]         = m.libpath .. "geneos-feed-bloomberg" .. m.libext,
		[ "library.skipVersionCheck" ] = "false",
		[ "library.debug.load" ]       = "false",
		verbose                        = "false"
	},
	bloomberg = {
		serverHost      = "bpipeserv01.ldn",
		serverPort      = "8194",
		applicationName = "market-data-monitor"
	},
	instruments = {
		VOD = "//blp/mktdata/VOD LN Equity",
		GBP = "//blp/mktdata/GBPUSD Curncy",
		EUR = "//blp/mktdata/EURUSD Curncy"
	},
	fields = {
		Bid      = "BID",
		Ask      = "ASK",
		Trade    = "LAST_PRICE",
		SrcTime  = "LAST_PRICE_TIME_TODAY_REALTIME"
	}
}

-- Exegy Feed
m.exegy = {
	feed = {
		type = "exegy",
		["library.filename"] = m.libpath .. "geneos-feed-exegy"  .. m.libext,
	},
	exegy = {
		serverHost      = "192.168.2.1",
		username        = "test",
		password        = "test",
	},
	instruments = {
		AAPL = "US:Q:AAPL",
		MSFT = "US:Q:MSFT",
		IBM = "US:Q:IBM"
	},
	fields = {
		Bid   = "Bid",
		Ask   = "Ask",
		SrcTime = "ExchHiTime",
		SeqNo = "Sequence"
	}
}

-- GL Feed
m.gl = {
	feed = {
		type = "gl",
		["library.filename"] = m.libpath .. "flm-feed-gl" .. m.libext
	},
	gl = {
		p3host  = "192.168.111.111",
		p3port  = 11111,
		slcNode = 1000
	},
	instruments = {
		AUF1  = "1,2,AUFRTE215002",
		SNIF1 = "1,2,SNIFDCM13001"
	},
	fields = {
		Bid      = 1,
		Ask      = 2,
		Trade    = 4,
		Time     = 6
	}
}

-- LUA Feed
m.lua = {
		feed = {
			type = "lua",
			["library.filename"] = m.libpath .. "geneos-feed-lua" .. m.libext
		},
		lua = {
			script = "path/to/script.lua",
			extraParam = "",
			otherParam = ""
		},
		instruments = { Inst1 = "anInstrument" },
		fields = {
			Bid     = "Bid",
			Ask     = "Ask",
			Trade   = "Trade",
			SrcTime = "SrcTime"
		}
	}

-- NYXT Feed, also known as Wombat MAMA
m.nyxt = {
		feed = {
			type = "nyxt",
			["library.filename"] = m.libpath .. "flm-feed-nyxt" .. m.libext
		},
		nyxt = {
			middleware = "wmw",
			transport = "wmw_tport",
			["dictionary.download"] = "true"
		},
		instruments = { MS = 'NASDAQ.Microsoft' },
		fields = {
			Bid    = "wBidPrice",
			Ask    = "wAskPrice",
			Trade  = "Reference Price",
			SrcTime = "wSrcTime"
		}
	}

-- Quant Feed
m.quant = {
	feed = {
		type = "quantFeed",
		[ "library.filename" ] = m.libpath .. "geneos-feed-quant" .. m.libext,
		[ "library.skipVersionCheck" ] = "false",
		[ "library.debug.load" ]       = "false",
		verbose = "true"
	},
	quantFeed = {
		serverHost      = "84.111.111.111",
		serverPort      = "6041",
		username        = "demo",
		password        = "myPassword",
		applicationName = "market-data-monitor"
	},
	instruments = {
		Inst1 = "XPAR@FR0010344960"
	},
	fields = {
		Ask = "ASK",
		Bid = "BID",
		Trade = "TRADE_PRICE",
		SrcTime = "SRCTIME"
	}
}

-- Thomson Reuters Feed
m.rfa = {
	feed = {
		type = "rfa",
		[ "library.filename" ]         = m.libpath .. "flm-feed-rfa" .. m.libext,
		[ "library.skipVersionCheck" ] = "false",
		[ "library.debug.load" ]       = "false",
		verbose                        = "false"
	},
	rfa = {
		configFile     = m.rfapath .. "rfa_omm.cfg",
		session        = "sessionrh1_omm",
		connectionType = "OMM"
	},
	instruments = {
		VOD  = "IDN_RDF.VOD.O",
		GBP  = "IDN_RDF.GBP=",
		EUR  = "IDN_RDF.EUR="
	},
	fields      = {
		Bid      = "BID",
		Ask      = "ASK",
		Trade    = "TRDPRC_1",
		SrcTime  = "QUOTIM_MS"
	}
}

m.rfa_001 = {
	feed = {
		type = "rfa",
		[ "library.filename" ]         = m.libpath .. "flm-feed-rfa" .. m.libext,
		[ "library.skipVersionCheck" ] = "false",
		[ "library.debug.load" ]       = "false",
		verbose                        = "false"
	},
	rfa = {
		configFile     = m.rfapath .. "rfa_omm.cfg",
		session        = "sessionrh2_omm",
		connectionType = "OMM"
	},
	instruments = {
		VOD  = "IDN_RDF.VOD.O",
		GBP  = "IDN_RDF.GBP=",
		EUR  = "IDN_RDF.EUR="
	},
	fields      = {
		Bid      = "BID",
		Ask      = "ASK",
		Trade    = "TRDPRC_1",
		SrcTime  = "QUOTIM_MS"
	}
}

m.rfa_elektronPulse = {
	feed = {
		type = "rfa",
		["library.filename"] = m.libpath .. "flm-feed-rfa" .. m.libext,
		["library.skipVersionCheck"] = "false",
		verbose="true",
	},
	rfa = {
		configFile = m.rfapath .. "rfa_ezd.cfg",
		session = "sessionezd_omm",
		connectionType = "OMM",
		messageModelType = "DOMAIN_TYPE_11",
	},
	--instruments should be set in the sampler
	fields = {
		sps_descr = "SPS_DESCR",
		sps_tme_ms = "SPS_TME_MS",
		sps_freq = "SPS_FREQ",
		sps_fail_t = "SPS_FAIL_T",
		l_h_stat = "L_H_STAT",
	}
}

m.rfa_topSPS = {
	feed = {
		type = "rfa",
		["library.filename"] = m.libpath .. "flm-feed-rfa" .. m.libext,
		["library.skipVersionCheck"] = "false",
		verbose="true",
	},
	rfa = {
		configFile = m.rfapath .. "rfa_ezd.cfg",
		session = "sessionezd_omm",
		connectionType = "OMM",
		messageModelType = "DOMAIN_TYPE_11",
		mapEntry = {
			keys = {
				emea = "EMEA",
				spsCheEnl = ".[SPSCHE-ENL",
				spsChecl = ".[SPSCHE-CL",
				spsCheJnx = ".[SPSCHE-JNX",
				dtcdpop = "DTC-D-PoP",
			},
			fields = {
				region = "REGION",
				sps_desc = "SPS_DESCR",
				venue_stat = "VENUE_STAT",
				ep_sco_cat = "EP_SCO_CAT",
			}
		}
	},
	--instruments should be set in the sampler
	fields = {
		sps_descr = "SPS_DESCR",
		sps_tme_ms = "SPS_TME_MS",
		sps_freq = "SPS_FREQ",
		sps_fail_t = "SPS_FAIL_T",
		l_h_stat = "L_H_STAT",
		sps_stype = "SPS_STYPE",
	}
}

m.rfa_providerSPS = {
	feed = {
		type = "rfa",
		["library.filename"] = m.libpath .. "flm-feed-rfa" .. m.libext,
		["library.skipVersionCheck"] = "false",
		verbose="true",
	},
	rfa = {
		configFile = m.rfapath .. "rfa_ezd.cfg",
		session = "sessionezd_omm",
		connectionType = "OMM",
		messageModelType = "DOMAIN_TYPE_11",
		mapEntry = {
			fields = {
				domainType = "DOMAINTYPE",
				nameType = "NAMETYPE",
				qos = "QOS",
				serviceId = "SERVICE_ID",
			}
		}
	},
	--instruments will be automatically set by the script
	fields = {
		prod_perm = "PROD_PERM",
		region = "REGION",
		dds_dso_id = "DDS_DSO_ID",
		sps_desc = "SPS_DESCR",
		sps_tme_ms = "SPS_TME_MS",
		sps_stype = "SPS_STYPE",
	}
}

m.rfa_subproviderSPS = {
	feed = {
		type = "rfa",
		["library.filename"] = m.libpath .. "flm-feed-rfa" .. m.libext,
		["library.skipVersionCheck"] = "false",
		verbose="true",
	},
	rfa = {
		configFile = m.rfapath .. "rfa_ezd.cfg",
		session = "sessionezd_omm",
		connectionType = "OMM",
	},
	--instruments will be automatically set by the script
	fields = {
		prod_perm = "PROD_PERM",
		arb_gapout = "ARB_GAPOUT",
		ttl_gapout = "TTL_GAPOUT",
		dds_dso_id = "DDS_DSO_ID",
		sps_prov = "SPS_PROV",
		dudt_ric = "DUDT_RIC",
		sps_desc = "SPS_DESCR",
		sps_tme_ms = "SPS_TME_MS",
		sps_freq = "SPS_FREQ",
		sps_fd_sts = "SPS_FD_STS",
		arb_gap_pd = "ARB_GAP_PD",
		sps_gp_dsc = "SPS_GP_DSC",
		sps_svc_tm = "SPS_SVC_TM",
		sps_fail_t = "SPS_FAIL_T",
		sps_pv_sts = "SPS_PV_STS",
		sps_sp_ric = "SPS_SP_RIC",
		ac_rd_sv_i = "AC_RD_SV_I",
		sp_inmap = "SP_INMAP",
		l_h_stat = "L_H_STAT",
		sps_stype = "SPS_STYPE",
	}
}

-- Trading Technologies (Windows only)
m.tradetech = {
		feed = {
			type = "tt",
			["library.filename"] = m.libpath .. "flm-feed-tt.dll"
		},
		tt = {
			exchange = "EUREX",
			["global.universal.username"] = "myUser",
			["global.universal.password"] = "myPassword",
			["global.universal.encoding"] = "plaintext"
		},
		instruments = {
			FXGL_1 = 'FXGL.FUTURE.Jun14',
			FXGL_2 = '=RTD("XTAPI.RTD","","Instr","EUREX","FXGL","FUTURE","Jun14","ASK")'
		},
		fields = {
			Bid   = "BID",
			Ask   = "ASK",
			Trade = "LAST",
			SrcTime = "SRCTIME"
		}
	}

-- Tutorial
m.tutorial = {
	feed = {
		type = "example",
		[ "library.filename" ]         = m.libpath .. "flm-feed-example" .. m.libext,
		[ "library.skipVersionCheck" ] = "true",
		[ "library.debug.load" ]       = "false",
		verbose                        = "false"
	},
	example = {},
	instruments = {
		GOOG = "DATA_SERVICE.GOOG",
		IBM  = "DATA_SERVICE.IBM"
	},
	fields      = {
		Bid   = "01_BID",
		Trade = "02_TRADE_PRICE",
		Ask   = "03_ASK"
	}
}

return m
