#!/bin/sh
# Script to run ingestion proxy standalone, forwarding to an Obcerv instance
# All exported values need to be set manually

# Settings for the Obcerv instance we want to send messages to
export INGESTION_HOST=dns-name of Obcerv Ingestion endpoint>
export INGESTION_USER=ingestion-api
# Ideally, this woud be looked up from a password manager or provided as a secret
export INGESTION_PWD=ingestion

# Path to the CA certificate we expect to authenticate the ingestion service
# If a certificate is not required this can be left unset
export OBCERV_CA_CERTIFICATE=obcerv.crt

# Path to the certificate and privare key used by the proxy
# This is required to allow TLS connection from the gateway to the proxy
# If TLS is not required
#     Leave these values unset 
#     Remove the tls-config block in the internal-grpc collector
export PROXY_CERTIFICATE=proxy.crt
export PROXY_KEY=proxy.pkcs8.key

# Port the ingestion proxy will listen on
export GRPC_PORT=7200

# Settings to allow password authentication of Gateway
# If it is not required that gateways authenticate with the proxy
#     Leave these values unset
#     Remove the iam-config block in the internal-grpc collector
export IAM_HOST=<dns-name of Obcerv endpoint>
export IAM_CLIENT_SECRET=<ingestion client secret>

# Settings for reporting self-monitoring metrics back to Geneos
export TCP_REPORTER_HOST=localhost
export TCP_REPORTER_PORT=19137 
export HOSTNAME=$(hostname -f)

# Path to the CA certificate we expect to authenticate the ingestion service
export COLLECTION_AGENT_DIR=.

# Run the collection agent
java -jar ${COLLECTION_AGENT_DIR}/collection-agent-*-exec.jar $1
