-- Load the API modules used by the script
local gs = require 'geneos.sampler'
gs.logMessage('INFO', "Starting")

-- Process configuration parameters
-- ================================
-- TODO

-- Configure and connect to market data sources
-- ============================================
-- TODO

-- Define functions to analyse the data
-- ====================================
-- TODO

-- Create data view(s)
-- ===================

-- Define columns and create view
local cols = { "instrument", "minSpread", "maxSpread", "ticksPerSample", "maxInterval", "tradePrice" }
local view = assert(gs.createView("spreads", cols))

-- Publish initial view data
view.headline.samples = 0
view.row['sample'] = { "our", "data", "will", "appear", "here"}
view.row['dummy'] = { ['ticksPerSample'] = 0 }
assert(view:publish())

-- Define the doSample function which will be called every sample
-- ==============================================================

local numSamples = 0
gs.doSample = function()
    numSamples = numSamples + 1
    view.headline.samples = numSamples
    assert(view:publish())
end

gs.logMessage('INFO', "Started OK")
-- End of script
