(function (document) {

    // Initialize the script after DOM is ready
    let init = function () {
        if (document.readyState !== 'loading') {
            // DOM is already ready, run event handler immediately
            eventHandler();
        } else {
            // Wait for DOMContentLoaded event before initializing
            document.addEventListener('DOMContentLoaded', eventHandler);
        }
    },

        // Set up event listeners for all anchor tooltips
        eventHandler = function () {
            // Get all elements with the class 'anchor-tooltip'
            let tooltips = document.querySelectorAll(".anchor-tooltip");

            // Attach click event listeners to each tooltip's parent anchor
            tooltips.forEach((tooltip) => listenTooltip(tooltip));
        },

        // Attach click listener to the parent anchor of the tooltip
        listenTooltip = function(tooltip) {
            let anchor = tooltip.parentElement;
            anchor.addEventListener('click', () => copyAnchor(anchor, tooltip));
        },

        // Copy the full anchor link to the clipboard and show the tooltip
        copyAnchor = function(anchor, tooltip) {
            // Build the full URL with the anchor's href
            const pathToCopy = window.location.hostname + window.location.pathname + anchor.getAttribute("href");

            // Copy the URL to the clipboard
            navigator.clipboard.writeText(pathToCopy);

            // Show visual feedback via the tooltip
            visibleTooltip(tooltip);
        },

        // Show the tooltip temporarily
        visibleTooltip = function(tooltip) {
            tooltip.style.display = "inline";
            
            // Hide tooltip after 500ms
            setTimeout(function () {
                hideTooltip(tooltip);
            }, 500);
        },

        // Hide the tooltip
        hideTooltip =  function(tooltip) {
            tooltip.style.display = "none";
        };

    // Start the script
    init();

})(document);
