(function (document) {

    // Initialize the script when the DOM is ready
    let init = function () {
      if (document.readyState !== 'loading') {
        eventHandler(); // DOM already loaded, start immediately
      } else {
        document.addEventListener('DOMContentLoaded', eventHandler); // Wait for DOM ready
      }
    },
  
    // Attach scroll and click handlers
    eventHandler = function () {
      let scrollMeBtn = document.getElementById("scrollMe");
  
      // Show or hide the "scroll to top" button based on scroll position
      window.addEventListener("scroll", () => {
        if (window.scrollY > 2) {
          scrollMeBtn.style.display = "block"; // Show the button when scrolled down
        } else {
          scrollMeBtn.style.display = "none"; // Hide when near the top
        }
      });
  
      // Scroll to the top of the page when the button is clicked
      scrollMeBtn.addEventListener("click", function () {
        setTimeout(() => {
          window.scrollTo(0, 0); // Instantly scrolls to top after short delay
        }, 300);
  
        // Alternative: smooth scrolling (uncomment below for smooth behavior)
        // window.scrollTo({ top: 0, behavior: 'smooth' });
      });
    }
  
    // Start the script
    init();
  
  })(document);
  