(function (document) {

    // Initialize the script when DOM is ready
    let init = function () {
        if (document.readyState !== 'loading') {
            eventHandler(); // DOM already loaded
        } else {
            document.addEventListener('DOMContentLoaded', eventHandler); // Wait for DOM to load
        }
    },

    // Check all table containers and adjust table layout if it fits within the container
    eventHandler = function () {
        document.querySelectorAll('.table-container').forEach((container) => {
            const table = container.querySelector('table');
            const containerWidth = container.offsetWidth;
            const tableWidth = table.offsetWidth;

            // If the table fits inside the container, apply fixed layout and word breaking
            if (tableWidth <= containerWidth) {
                table.style.tableLayout = 'fixed';
                table.style.wordBreak = 'break-word';
            }
        });
    }

    // Call the init function to start the process
    init();

    // Expose the init function under a global object for external calls if needed
    exposeTableLayout = { tableLayout: init }

})(document);
