(function(document) {

    // Initialize the script once the DOM is ready
    let init = function() {
      if (document.readyState !== 'loading') {
        eventHandler(); // If DOM is ready, run the event handler
      } else {
        document.addEventListener('DOMContentLoaded', eventHandler); // Otherwise, wait for DOMContentLoaded
      }
    },
  
    // Loop through all elements with the class 'external-file'
    eventHandler = function() {
      let externalFiles = document.getElementsByClassName('external-file');
  
      for (let i = 0; i < externalFiles.length; i++) {
        // Check if the element has a 'data-source' attribute
        if (externalFiles[i].hasAttribute('data-source')) {
          getExternalFile(externalFiles[i]); // Load the external file into the element
        }
      }
    },
  
    // Fetch the external file content and insert it into the element
    getExternalFile = function (externalFile) {
      let source = externalFile.dataset.source; // Base path from data-source
      let chromaSource = source + '.html'; // First attempt: HTML version (for syntax highlighting)
      let request = new XMLHttpRequest();
  
      // Try to get the .html version
      request.open('GET', chromaSource, true);
      request.onreadystatechange = function() {
        if (this.readyState === XMLHttpRequest.DONE) {
          // If successful, insert the response (highlighted HTML) into the container
          if (this.status >= 200 && this.status < 400) {
            externalFile.insertAdjacentHTML('beforeend', this.response);
          }
  
          // If .html fails (e.g., 404), fall back to fetching the raw source file
          else if (this.status >= 400 && this.status < 500) {
            request.open('GET', source, true);
            request.onreadystatechange = function() {
              if (this.readyState === XMLHttpRequest.DONE) {
                if (this.status >= 200 && this.status < 400) {
                  // Wrap the raw file contents in <pre><code> tags and insert
                  externalFile.insertAdjacentHTML(
                    'beforeend',
                    '<pre><code>' + this.responseText + '</code></pre>'
                  );
                } else {
                  // If both requests fail, show fallback message
                  let naMsg = 'This resource is not available at this moment.' +
                              ' Please, try again later.';
  
                  externalFile.insertAdjacentHTML(
                    'beforeend',
                    '<pre><code>' + naMsg + '</code></pre>'
                  );
                  externalFile.classList.add('not-available');
                }
              }
            }
            request.send(); // Send fallback request
          }
        }
      }
      request.send(); // Send initial request
    };
  
    // Start the script
    init();
  
  })(document);
  