((document) => {
    // Initialize the script execution
    let init = () => {
            // Check if the document is already loaded
            if (document.readyState !== 'loading') {
                eventHandler(); // If loaded, run the event handler
            } else {
                // If not loaded yet, wait for the DOMContentLoaded event to trigger the event handler
                document.addEventListener('DOMContentLoaded', eventHandler);
            }
        },

        // Event handler that will be executed after the document is ready
        eventHandler = () => {

            const highlightDiv = document.querySelectorAll('.highlight')

            if (highlightDiv) { // check if highlight div exists 
                highlightDiv.forEach((highlightDiv) => { // Iterate over all elements with the 'highlight' class
                    const codeToWrap = highlightDiv.querySelector('.chroma > code'); // Select the code block inside the highlightDiv
                    // Check if the code block has 3 or more lines of code
                    // Only add the wrap button if the code block meets the condition
                    if (codeToWrap.children.length >= 3) {
                        // Create and insert the wrap button into the highlightDiv
                        createWrapButton(highlightDiv);

                        const button = highlightDiv.querySelector('.wrap-code-button');

                        // Prevent duplicate event listeners by replacing the button with a clone
                        // This avoids issues caused by event listener stacking when the modal is reopened
                        const newButton = button.cloneNode(true);
                        button.replaceWith(newButton);

                        // Attach the click event listener to the new button
                        // When clicked, it toggles the wrap state for the code block
                        newButton.addEventListener('click', () => setWrapActive(newButton, codeToWrap));
                    }
                });
            }
        },

        // Create and insert a wrap button into the given highlightDiv
        createWrapButton = (highlightDiv) => {
            let button = document.createElement('button');
            button.className = 'wrap-code-button'; // Assign a class to the button
            button.type = 'button'; // Set the button type
            button.setAttribute('title', 'Wrap code'); // add tool tip
            button.appendChild(createSvg()); // Add the icon to the button

            // Insert the button at the beginning of the highlightDiv if it doesn't already exist
            if (!highlightDiv.querySelector('.wrap-code-button')) {
                highlightDiv.insertBefore(button, highlightDiv.firstChild);
            }
        },

        // Toggle the wrapping of the code block when the button is clicked
        setWrapActive = (button, codeToWrap) => {
            // Toggle the 'wrap-code-text' class to apply wrapping styles
            const isActive = codeToWrap.classList.toggle('wrap-code-text');

            // Toggle the button's active state
            button.classList.toggle('wrap-code-button-active', isActive);

        },

        // Create the SVG icon for the wrap button
        createSvg = () => {
            let icon = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
                useElem = document.createElementNS('http://www.w3.org/2000/svg', 'use');

            icon.classList.add('icon'); // Add the 'icon' class to the icon
            useElem.setAttributeNS('http://www.w3.org/1999/xlink', 'xlink:href', '#content_wrap'); // Set the icon's reference, can be found in core-docs/core/themes/itrs/assets/sprites/material.svg
            icon.appendChild(useElem); // Append the icon to the SVG

            return icon; // Return the created icon
        };

    // Initialize the script
    init();

    // Expose the wrap code function for external usage
    exposeWrapCode = {
        wrapCode: init, // Allow external scripts to call the init function
    }

})(document);