﻿// JS for rate this topic form

(function (document) {

    'use strict';

    // Initialize the script when the DOM is ready
    let init = function () {
            if (document.readyState !== 'loading') {
                eventHandler();
            } else {
                document.addEventListener('DOMContentLoaded', eventHandler);
            }
        },

        // Main event handler that sets up event listeners for all form interactions
        eventHandler = function () {

            const rateTopicYes = document.getElementById('rate-this-topic-yes');
            const rateTopicNo = document.getElementById('rate-this-topic-no');

            const rateMappings = [{
                    element: rateTopicYes,
                    panelIndex: 1
                },
                {
                    element: rateTopicNo,
                    panelIndex: 2
                }
            ];

            rateMappings.forEach(({
                element,
                panelIndex
            }) => {
                if (element) {
                    element.addEventListener('click', event => {
                        showYesNoPanel(event.target, getPanel(panelIndex));
                    });
                }
            });


            // Panels 1 & 2: "Skip" buttons return to initial panel (0)
            let cancelButtons = document.getElementsByClassName('rate-this-topic-skip');
            for (let i = 0; i < cancelButtons.length; i++) {
                cancelButtons[i].addEventListener('click', function (event) {
                    let thisPanel = event.target.closest('.rate-this-topic-panel');
                    showFirstPanel(thisPanel); // Return to panel 0
                });
            }

            // Panels 1 & 2: "Send Feedback" buttons submit form
            let sendFeedbackButtons = document.getElementsByClassName('rate-this-topic-send-feedback');
            for (let i = 0; i < sendFeedbackButtons.length; i++) {
                sendFeedbackButtons[i].addEventListener('click', function (event) {
                    let thisPanel = event.target.closest('.rate-this-topic-panel');
                    createJiraTicket(thisPanel); // Submit feedback data
                    showFinalMessage(thisPanel); // Show thank you panel (3)
                });
            }
        },

        // Save the Yes/No selection and switch from panel 0 to panel 1 or 2
        showYesNoPanel = function (element, panel) {
            saveYesNoValue(element.value); // Store user selection in hidden input
            switchPanel(getPanel(0), panel); // Switch panel view
        },

        // Save Yes/No value to hidden input (or create it if it doesn't exist)
        saveYesNoValue = function (value) {
            let hiddenElement = document.getElementById('rate-this-topic-yes-no');
            if (hiddenElement) {
                hiddenElement.setAttribute('value', value);
            } else {
                let containerElement = document.getElementsByClassName('rate-this-topic');
                if (containerElement.length > 0) {
                    containerElement[0].appendChild(buildHiddenInput(value));
                }
            }
        },

        // Create a hidden input element with Yes/No value
        buildHiddenInput = function (value) {
            let input = document.createElement('input');
            input.setAttribute('type', 'hidden');
            input.setAttribute('id', 'rate-this-topic-yes-no');
            input.setAttribute('value', value);
            return input;
        },

        // Switch to thank you panel (panel 3)
        showFinalMessage = function (panel) {
            switchPanel(panel, getPanel(3));
        },

        // Return to the initial panel (panel 0)
        showFirstPanel = function (panel) {
            switchPanel(panel, getPanel(0));
        },

        // Collect form data and submit it via POST request to Jira endpoint
        createJiraTicket = function (context) {
            // Get CAPTCHA response
            let rateThisTopicCaptcha = context.getElementsByClassName('g-recaptcha-response');
            if (rateThisTopicCaptcha.length > 0) {
                rateThisTopicCaptcha = rateThisTopicCaptcha[0].value;
            } else {
                rateThisTopicCaptcha = '';
            }

            // Get Yes/No value from hidden input
            let rateThisTopicYesNo = document.getElementById('rate-this-topic-yes-no').value;
            let rateThisTopicThoughts = '';
            let rateThisTopicHowToImprove = [];

            // Collect thoughts and optionally reasons (if user selected No)
            if (rateThisTopicYesNo == 'Yes') {
                rateThisTopicThoughts = document.getElementById('rate-this-topic-thoughts-1').value;
            } else {
                rateThisTopicThoughts = document.getElementById('rate-this-topic-thoughts-2').value;

                // Get selected reasons for "No"
                let inputChecked = context.querySelectorAll('input:checked');
                for (let i = 0; i < inputChecked.length; i++) {
                    rateThisTopicHowToImprove.push(inputChecked[i].value);
                }
            }

            // Prepare request payload
            let requestParams = {
                'rate-this-topic-recaptcha': rateThisTopicCaptcha,
                'rate-this-topic-yes-no': rateThisTopicYesNo,
                'rate-this-topic-thoughts': rateThisTopicThoughts,
            };

            // Add improvement reasons if any were selected
            if (rateThisTopicHowToImprove.length > 0) {
                requestParams['rate-this-topic-how-to-improve'] = rateThisTopicHowToImprove;
            }

            // Send POST request to Jira endpoint
            ajaxPost(
                getBaseUrl('connector') + '/jira/create', {
                    'Content-type': 'application/x-www-form-urlencoded'
                },
                urlEncodeParams(requestParams)
            );
        },

        // Get reference to a panel by index (0 to 3)
        getPanel = function (index) {
            return document.getElementById('rate-this-topic-panel-' + index);
        },

        // Switch between panels with fade effect
        switchPanel = function (currentPanel, nextPanel) {
            fadeOutElement(
                currentPanel,
                function () {
                    showElement(nextPanel, ['fade-out']);
                }
            );
        };

    // Start the script
    init();

})(document);

// Captcha implementation.

/**
 * Handle positive feedback reCAPTCHA callback.
 *
 * @param {string} response
 */
function captchaVerifyCallback1(response) {
    disableElement(
        document.querySelector(
            '#rate-this-topic-panel-1 .rate-this-topic-send-feedback'
        ),
        response == ''
    );
}

/**
 * Handle negative feedback reCAPTCHA callback.
 *
 * @param {string} response
 */
function captchaVerifyCallback2(response) {
    disableElement(
        document.querySelector(
            '#rate-this-topic-panel-2 .rate-this-topic-send-feedback'
        ),
        response == ''
    );
}