(function (document) {

    // Initialize the script when DOM is ready
    let init = function () {
            if (document.readyState !== 'loading') {
                eventHandler(); // DOM already loaded
            } else {
                document.addEventListener('DOMContentLoaded', eventHandler); // Wait for DOM to load
            }
        },

        eventHandler = function () {
            const collapseBtn = document.querySelector(".collapse-lhn-btn");
            if (!collapseBtn) return;
            
            collapseBtn.addEventListener("click", collapseLHN);
        }

    const collapseLHN = () => {
        const sidebarNav = document.querySelector(".sidebar-navigation");
        if (!sidebarNav) return;
        // elements to hide if lhn is collapsed
        //Directly define the elements to toggle visibility
        const elementsToToggle = [
            document.querySelector(".sidebar-search"),
            document.querySelector(".nav-product-toc"),
            document.querySelector(".nav-scrollable"),
            document.querySelector(".nav-external-links"),
        ];

        // collapse icon
        const collapseIcon = document.querySelector(".collapse-lhn-icon");

        const isCollapsed = sidebarNav?.classList.toggle("sidebar-collapse");

        elementsToToggle.forEach(el => {
            if (!el) return;
            el.classList.toggle("lhn-collapse-items-hide", isCollapsed);
        });

        // Directly use the collapse icon and not pass its value from one function to another
        if (!collapseIcon) return
        collapseIcon.classList.toggle("collapse-lhn-icon-override-right");
    }

    init();

})(document);