// This script handles margin formatting for label elements when they are surrounded by text nodes.
// Text nodes are not treated as actual elements and are therefore ignored by CSS selectors.


(function (document) {

    // Initialize the script when DOM is ready
    let init = function () {
            if (document.readyState !== 'loading') {
                eventHandler(); // DOM already loaded
            } else {
                document.addEventListener('DOMContentLoaded', eventHandler); // Wait for DOM to load
            }
        },


        eventHandler = function () {
            const labels = document.querySelectorAll(".label-status"); // get all labels
            labels.forEach((label) => {
                const prev = label.previousSibling; // get previous sibling node

                if (prev && prev.nodeType === 3) { // validate if prev exists and if its nodeType is 'Node.TEXT_NODE' ref: https://developer.mozilla.org/en-US/docs/Web/API/Node/nodeType#node.text_node

                    const siblingValue = prev.nodeValue;
                    if (!siblingValue?.startsWith("\n") && !siblingValue?.startsWith(" ")) { // add margins if previous sibling text node value does not start in a new line or white space
                        label.classList.add("add-margin-label");
                    }
                }
            })
        }

    // Call the init function to start the process
    init();

    // Expose the init function under a global object for external calls if needed
    exposeLabelFormat = { labelFormat: init }

})(document);