((document) => {
    const init = () => {
        if (document.readyState !== "loading") {
            eventHandler();
        } else {
            document.addEventListener("DOMContentLoaded", eventHandler);
        }
    };

    const eventHandler = () => {
        // get table modal placeholder, defined in core-docs/core/themes/itrs/layouts/partials/modal-table.html
        const modalPlaceholder = document.querySelector(".table-modal-placeholder");
        const modalExitZone = document.querySelector(".table-modal-exit-zone");
        const modalTableContainer = document.getElementById("table01");
        const collapseBtn = document.querySelector("#collapse-btn");

        // add click events to close the modal via the background (modalExitZone) or the collapse button.
        modalExitZone.addEventListener("click", () => closeTableModal(modalPlaceholder, modalTableContainer));
        collapseBtn.addEventListener("click", () => closeTableModal(modalPlaceholder, modalTableContainer));

        // get all buttons using id #expand-btn, defined in core-docs/core/themes/itrs/layouts/_default/_markup/render-table.html
        const expandButtons = document.querySelectorAll("#expand-btn");
        expandButtons.forEach((expandButtonElement) => listenTableModals(modalPlaceholder, expandButtonElement, modalTableContainer));

        // handle legacy tables
        const tableContainers = document.querySelectorAll(".table-container");
        tableContainers.forEach((container) => {
            const parentContentNode = container.parentNode
            const table = container.children[0]
            const expandBtnLegacy = createExpandButton(); // create button element for legacy table

            if (table.classList.contains("legacy-table")) { // select containers with legacy-table class only and insert the expand button before the container
                parentContentNode.insertBefore(expandBtnLegacy, container);
                listenTableModals(modalPlaceholder, expandBtnLegacy, modalTableContainer);
            }
        })

    };

    // function to create expand button, currently intended for legacy tables only as buttons are now added in core-docs/core/themes/itrs/layouts/_default/_markup/render-table.html
    const createExpandButton = function () {
        const expandBtn = document.createElement("button");
        expandBtn.className = "table-modal-btn";
        expandBtn.id = "expand-btn";
        expandBtn.innerHTML = `<svg id="fullscreen-icon"></svg>Expand table`

        return expandBtn;
    };

    const listenTableModals = (modalPlaceholder, expandButtonElement, modalTableContainer) => {
        const currentTable = expandButtonElement.nextElementSibling; // get the table by selecting the next element sibling of the expand button
        const clonedTable = currentTable.cloneNode(true); // clone the table to create a copy for the modal

        // add a sticky-header class to cloned tables to ensure headers remain visible during scrolling in the modal.
        clonedTable.classList.add("sticky-header");

        expandButtonElement.addEventListener("click", () => setTableModal(modalPlaceholder, clonedTable, modalTableContainer));
    };

    const setTableModal = (modalPlaceholder, clonedTable, modalTableContainer) => {

        modalPlaceholder.style.display = "flex";
        modalTableContainer.append(clonedTable);

        // invoking exposed functions necessary for tables
        // also checks if the exposed object with the function exists
        if (typeof exposeCopyCode === "object") {
            // invoke the exposed copy code function defined in core-docs/core/themes/itrs/assets/js/copy-code.js
            exposeCopyCode.copyCode();
        }
        if (typeof exposeWrapCode === "object") {
            // invoke the exposed wrap code function defined in core-docs/core/themes/itrs/assets/js/wrap-code.js
            exposeWrapCode.wrapCode();
        }
        if (typeof exposeTableLayout === "object") {
            // invoke the exposed table layout function defined in core-docs/core/themes/itrs/assets/js/table-layout.js
            exposeTableLayout.tableLayout();
        }

        if (typeof exposeLabelFormat === "object") {
            // invoke the exposed table layout function defined in core-docs/core/themes/itrs/assets/js/label-format.js
            exposeLabelFormat.labelFormat();
        }

        // reset the table scroll view to top on every modal interaction
        modalTableContainer.scrollTo({
            top: 0
        })

        // disable background scrolling while the modal is active.
        modalPlaceholder.parentNode.classList.add("disable-scroll");

        if (modalPlaceholder.style.display === "flex") {

            // dynamically add a listener for the Escape key to close the modal.
            // listener is removed when the modal is closed to prevent memory leaks or duplicate event handling.
            document.addEventListener("keydown", (e) =>
                handleEscapeKey(e, modalPlaceholder, modalTableContainer), {
                    once: true
                }
            )
        }
    };

    // function to close modal
    const closeTableModal = (modalPlaceholder, modalTableContainer) => {
        modalPlaceholder.style.display = "none";
        modalTableContainer.innerHTML = ""; // removes the table in the container
        modalPlaceholder.parentNode.classList.remove("disable-scroll"); // bring back scrolling again when modal is not active
    };

    // "Esc" key event listener to close modal
    const handleEscapeKey = (e, modalPlaceholder, modalTableContainer) => {
        if (e.key === "Escape") {
            closeTableModal(modalPlaceholder, modalTableContainer)
        }
    }

    init();
})(document);