(function (document) {

    let init = function () {
        if (document.readyState !== 'loading') {
            eventHandler();
        } else {
            document.addEventListener('DOMContentLoaded', eventHandler);
        }
    },

        eventHandler = function () {

            // get modal placeholder, defined in core-docs/core/themes/itrs/layouts/partials/modal-img.html 
            const modal = document.getElementById("modalImg");
            if (modal === null) {
                return;
            }
            var modalImg = document.getElementById("modal01");
            var captionText = document.getElementById("modal-caption");

            // Get the image and insert it inside the modal - use its "alt" text as a caption
            var images = document.querySelectorAll(".content-img");

            images.forEach((image) => listenImageModals(modal, image, modalImg, captionText));

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks on <span> (x), close the modal
            span.addEventListener('click', () => closeImageModal(modal));

        },

        closeImageModal = function(modal) {
            modal.style.display = "none";
            modal.ownerDocument.body.classList.remove("disable-scroll");
        },

        listenImageModals = function(modal, image, modalImg, captionText) {
            image.addEventListener('click', () => setImageModal(modal, image, modalImg, captionText));
        },
        
        setImageModal = function(modal, image, modalImg, captionText) {
            modal.style.display = "block";
            modal.ownerDocument.body.classList.add("disable-scroll");
            modalImg.src = image.src;
            modalImg.alt = image.alt;
            captionText.innerHTML = image.alt;

            // dynamically add a listener for the Escape key to close the modal.
            // listener is removed when the modal is closed to prevent memory leaks or duplicate event handling.
            document.addEventListener("keydown", (e) =>
                handleEscapeKey(e, modal), {
                    once: true
                }
            )
        };

        // "Esc" key event listener to close modal
        const handleEscapeKey = (e, modal) => {
            if (e.key === "Escape") {
                closeImageModal(modal)
            }
        }

        

    init();
})(document);