-- Script to set up configurartion for an FLM-like sampler

-- vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
-- Do not edit this part of this script

local gh = require "geneos.helpers"

--- Global variable, shared with flm_to_mdm.lua
config = {
    fields      = { codes     = {} },
    instruments = { codes     = {} },
    feeds       = { compFeeds = {} },
}

--- Set up the feed configuration structure for a feed.
-- Preconditions:
-- 	The field codes for the feed should be set up in config.fields.codes[feed]
-- 	The instrument codes for the feed should be set up in config.instrument.codes[feed]
-- Postcondition:
--	The feed configuration structure will have been added to config.feeds
local configureFeed = function (name, isbase, feed)
	feed.name = name
	feed.instruments = assert(gh.zip(config.instruments.names, config.instruments.codes[name]))
	feed.fields = assert(gh.zip(config.fields.names, config.fields.codes[name]))
	if isbase then
		assert(not config.feeds.baseFeed, "Cannot have more than one base feed")
		config.feeds.baseFeed = feed
	else
		config.feeds.compFeeds[#config.feeds.compFeeds+1] = feed
	end
end

--- Insert configured instrument names into a template.
-- @param template A format string in which '%s' will be replaced by each instrument name in turn.
-- @return         A sequence of instrument codes formed by expanding the template
local makeInstrumentGroup = function(template)
	local inst_names = config.instruments.names
	local instrumentList = {}
	for i = 1, #inst_names do
		instrumentList[i] = string.format(template, inst_names[i])
	end
	return instrumentList
end
-- vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
-- Edit this part of the script to reflect the required configuration

-- Field configuration
config.fields.names             = { "Trade",      "Bid", "Ask" }
config.fields.codes['baseFeed'] = { "LAST_PRICE", "BID", "ASK" }
config.fields.codes['compFeed'] = { "LAST_PRICE", "BID", "ASK" }
-- Add fields for additional feeds here

-- Instrument configuration
config.instruments.names             = { "GBPEUR",                      "GBPJPY",                       "GBPUSD" }
config.instruments.codes['baseFeed'] = { "//blp/mktdata/GBPEUR Curncy", "//blp/mktdata/GBPJPY Curncy",  "//blp/mktdata/GBPUSD Curncy" }
config.instruments.codes['compFeed'] = makeInstrumentGroup("//blp/mktdata/%s Curncy")
-- Add instruments for additional feeds here

-- Feed configuration
-- Base feed
configureFeed("baseFeed", true,
{
	feed = { type = "bloomberg", ["library.filename"] = "geneos-feed-bloomberg.so"},
	bloomberg  = { serverHost = "bpipe.ldn.itrs" }
})
-- Comparison feed 1
configureFeed("compFeed", false,
{
	feed = { type = "bloomberg", ["library.filename"] = "geneos-feed-bloomberg.so"},
	bloomberg  = { serverHost = "bpipe1.ldn.itrs" }
})
-- Add additional comparison feeds here, if required


-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
