-- Load the API modules used by the script
local gs = require 'geneos.sampler'
local md = require 'geneos.marketdata'
gs.logMessage('INFO', "Starting")

-- Process configuration parameters
-- ================================
-- TODO

-- Configure and connect to market data sources
-- ============================================

-- Feed configuration is stored in a Lua table
local feedConfiguration = {}

-- Feed Controller configuration
feedConfiguration.feed = {
    type = "example",
    ["library.filename"] = "flm-feed-example.so",
}

-- Feed adapter configuration
feedConfiguration.example = {
    publishingPeriod = 200,
}

-- Define the set of instruments
-- Instrument subscriptions are defined as a mapping from display name to stock code
feedConfiguration.instruments = {
    GOOG = "DATA_SERVICE.GOOG",
    IBM  = "DATA_SERVICE.IBM",
}

-- Define the set of fields
-- Fields are defined as a mapping from display name to field code
feedConfiguration.fields = {
    Bid   = "01_BID",
    Trade = "02_TRADE_PRICE",
    Ask   = "03_ASK",
}

-- Create and start a feed using the above config
local tutorialFeed = assert(md.addFeed("Tutorial-Feed", feedConfiguration))
tutorialFeed:start()

-- Define functions to analyse the data
-- ====================================
-- TODO

-- Create data view(s)
-- ===================

-- Define columns and create view
local cols = { "instrument", "minSpread", "maxSpread", "ticksPerSample", "maxInterval", "tradePrice" }
local view = assert(gs.createView("spreads", cols))

-- Publish initial view data
view.headline.samples = 0
assert(view:publish())

-- Define the doSample function which will be called every sample
-- ==============================================================

local numSamples = 0
gs.doSample = function()
    numSamples = numSamples + 1
    view.headline.samples = numSamples

    local firstTick, lastTick = tutorialFeed:getTicks('GOOG')
    local lastTrade = lastTick and lastTick.field['Trade']
    view.row['GOOG'] = { tradePrice = lastTrade }

    firstTick, lastTick = tutorialFeed:getTicks('IBM')
    lastTrade = lastTick and lastTick.field['Trade']
    view.row['IBM'] = { tradePrice = lastTrade }

    assert(view:publish())
end

gs.logMessage('INFO', "Started OK")
-- End of script
